(function scriptLoader() {
  window.addEventListener('scroll', initFunc, false);
  window.addEventListener('mousemove', initFunc, false);

  function initFunc() {
    window.removeEventListener('scroll', initFunc, false);
    window.removeEventListener('mousemove', initFunc, false);
    console.log('scriptLoader: ' + Date.now());

    function appendScript(src) {
      const s = 'script';
      const firstScript = document.getElementsByTagName(s)[0];
      const script = document.createElement(s);
      script.defer = true;
      script.src = src;
      firstScript.parentNode.insertBefore(script, firstScript);
    }

    // Google Tag Manager
    const l = 'dataLayer';
    window[l] = window[l] || [];
    window[l].push({ 'gtm.start': new Date().getTime(), event: 'gtm.js' });
    const dl = l != 'dataLayer' ? '&l=' + l : '';
    const id = 'GTM-PTRGMFG';
    appendScript('https://www.googletagmanager.com/gtm.js?id=' + id + dl);

    // dmmWidget
    appendScript('/js/dmmWidgets.js');

    // // TocBot
    // const k = d.createElement(s);
    // k.src =
    //   'https://cdnjs.cloudflare.com/ajax/libs/tocbot/4.20.1/tocbot.min.js';
    // f.parentNode.insertBefore(k, f);
    // if (typeof tocbot !== 'undefined') {
    //   // eslint-disable-next-line no-undef
    //   tocbot.init({
    //     tocSelector: '.toc',
    //     contentSelector: '.post',
    //     headingSelector: 'h1, h2, h3',
    //     scrollSmoothOffset: -80,
    //   });
    // }
  }
})();

